﻿const { axios } = require("../network");

const mfaResend = document.getElementById("mfa-resend");
const mfaLoginButton = document.getElementById("submit-btn");
mfaResend.addEventListener("click", onResend);

const inputs = document.getElementsByClassName("login-mfa-input");
for (let input of inputs) {
    input.addEventListener("input", onCharacterEntered);
    input.addEventListener("focus", function() { this.select(); });
    input.addEventListener("paste", onMfaCodePasted);
    input.addEventListener("keydown", onCharacterRemoved);
}

function onResend(e) {
    e.preventDefault();
    disableMfaResendCode();

    axios
        .get("Account/ResendMfaCode")
        .then(() => {
            startMfaResendCodeTimer();
            removeMfaResendCodeError();
        }).catch(() => {
            enableMfaResendCode();
            const mfaResendCodeError = document.getElementById("mfa-resend-error");
            if (!mfaResendCodeError) {
                addMfaResendCodeError();
            }
        });
}

function addMfaResendCodeError() {
    const mfaValidationSummary = document.getElementById("mfa-validation-summary");
    if (mfaValidationSummary) {
        if (!mfaValidationSummary.classList.contains("validation-summary-errors")) {
            mfaValidationSummary.classList.add("validation-summary-errors");
        }

        const ul = mfaValidationSummary.querySelector("ul");
        if (ul) {
            const mfaResendCodeError = document.createElement("li");
            mfaResendCodeError.id = "mfa-resend-error";
            mfaResendCodeError.innerText = resources.MfaResendCodeError;
            ul.appendChild(mfaResendCodeError);
        }
    }
}

function enableMfaResendCode() {
    mfaResend.setAttribute("href", "#");
    mfaResend.addEventListener("click", onResend);
}

function disableMfaResendCode() {
    mfaResend.removeEventListener("click", onResend);
    mfaResend.removeAttribute("href");
}

function startMfaResendCodeTimer() {
    const mfaResendTimerSeconds = document.getElementById("mfa-resend-timer-seconds");
    if (mfaResendTimerSeconds) {
        mfaResendTimerSeconds.innerText = 30;
    }

    const mfaResendTimer = document.getElementById("mfa-resend-timer");
    if (mfaResendTimer) {
        mfaResendTimer.classList.remove("hidden");
    }

    countDownMfaResendCodeTimer();
}

function countDownMfaResendCodeTimer() {
    setTimeout(function () {
        const mfaResendTimerSeconds = document.getElementById("mfa-resend-timer-seconds");
        if (mfaResendTimerSeconds) {
            const secondsLeft = mfaResendTimerSeconds.innerText - 1;

            if (secondsLeft > 0) {
                mfaResendTimerSeconds.innerText = secondsLeft;
                countDownMfaResendCodeTimer();
            }
            else {
                stopMfaResendCodeTimer();
            }
        }
    }, 1000);
}

function stopMfaResendCodeTimer() {
    const mfaResendTimer = document.getElementById("mfa-resend-timer");
    if (mfaResendTimer) {
        mfaResendTimer.classList.add("hidden");
    }

    enableMfaResendCode();
}

function removeMfaResendCodeError() {
    const mfaResendCodeError = document.getElementById("mfa-resend-error");
    if (mfaResendCodeError) {
        mfaResendCodeError.remove();
    }
}

function onCharacterEntered(event) {
    const nextTabIndex = this.tabIndex;
    const nextEl = inputs[nextTabIndex];
    const number = parseInt(this.value);
    if (!isFinite(number)) {
        this.value = "";
    }

    if (this.value.length > this.maxLength) {
        this.value = this.value.slice(0, this.maxLength);
    }

    if (!nextEl && this.value) {
        mfaLoginButton.focus();
    }

    if (nextEl && !(this.value.length < this.maxLength)) {
        nextEl.focus();
    } 
}

function onCharacterRemoved(event) {
    const element = event.currentTarget
    const index = element.tabIndex - 1;
    if (!element.value && event.key === "Backspace" && index) {
        inputs[index - 1].focus();
    } 
};

function onMfaCodePasted(event) {
    event.preventDefault();
    const clip = event.clipboardData.getData('text');
    const mfaCode = clip.replace(/\s/g, "");
    const mfaCodeArray = [...mfaCode];

    let index = 0;
    for (let input of inputs) {
        input.value = mfaCodeArray[index++] ?? "";
    }

    if (mfaCode.length >= inputs.length) {
        mfaLoginButton.focus();
    } else {
        inputs[mfaCode.length - 1].focus();
    }
};